<?php
/**
 * Child functions and definitions.
 */

add_action( 'astra_header', 'cb_child_do_header', -999 );
add_action( 'astra_footer', 'cb_child_do_footer', -999 );

/**
 * Apply Crocoblock custom headers
 *
 * @return [type] [description]
 */
function cb_child_do_header() {
	cb_child_process_location( 'header', true );
}

/**
 * Apply Crocoblock custom footers
 *
 * @return [type] [description]
 */
function cb_child_do_footer() {
	cb_child_process_location( 'footer', true );
}

/**
 * Process single location
 *
 * @return void
 */
function cb_child_process_location( $location = null, $cleanup = false ) {

	if ( ! function_exists( 'jet_theme_core' ) ) {
		return false;
	}
	if( ! defined( 'ELEMENTOR_VERSION' ) ) {
		return false;
	}

	$done = jet_theme_core()->locations->do_location( $location );

	if ( $done && $cleanup ) {
		$hook = current_filter();
		remove_all_actions( $hook );
	}

	return $done;

}




//** *Enable upload for webp image files.*/
function webp_upload_mimes($existing_mimes) {
    $existing_mimes['webp'] = 'image/webp';
    return $existing_mimes;
}
add_filter('mime_types', 'webp_upload_mimes');

//** * Enable preview / thumbnail for webp image files.*/
function webp_is_displayable($result, $path) {
    if ($result === false) {
        $displayable_image_types = array( IMAGETYPE_WEBP );
        $info = @getimagesize( $path );

        if (empty($info)) {
            $result = false;
        } elseif (!in_array($info[2], $displayable_image_types)) {
            $result = false;
        } else {
            $result = true;
        }
    }

    return $result;
}
add_filter('file_is_displayable_image', 'webp_is_displayable', 10, 2);
